<?php
header('Content-Type: application/json');

$host = $_GET['h'] ?? '';
$key  = $_GET['k'] ?? '';

$file = __DIR__ . '/licenses.json';

if (!file_exists($file)) {
    echo json_encode(["s" => "bad"]);
    exit;
}

$data = json_decode(file_get_contents($file), true);

$response = ["s" => "bad"];

if (!empty($data['licenses'])) {
    foreach ($data['licenses'] as $lic) {

        if (
            $lic['domain'] === $host &&
            $lic['token']  === $key &&
            $lic['status'] === 'active'
        ) {
            $response = [
                "s" => "ok",
                "t" => $lic['tier'] === 'paid' ? 'p' : 'f'
            ];
            break;
        }
    }
}

echo json_encode($response);